package cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo;

import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import java.util.List;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户总订单分页 Request VO")
@Data
public class CustomerOrderPageReqVO extends PageParam {

    @Schema(description = "id集合")
    private List<Long> ids;

    @Schema(description = "订单编号")
    private String code;

    @Schema(description = "订单状态", example = "2")
    private CustomerOrderStatus orderStatus;

    @Schema(description = "订单状态集合")
    private List<String> orderStatusList;

    @Schema(description = "客户id", example = "20189")
    private Long customerId;

    @Schema(description = "收获仓库id", example = "27065")
    private Long warehouseId;

    @Schema(description = "收获库区id", example = "26507")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;

    @Schema(description = "配送模式")
    private DeliveryMode deliveryMode;

    @Schema(description = "采购订单数", example = "12099")
    private Integer productCount;

    @Schema(description = "供应商数", example = "8062")
    private Integer supplierCount;

    @Schema(description = "预计配送开始时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] planDeliveryEndTime;

    @Schema(description = "订单总金额(分)")
    private Integer orderAmount;

    @Schema(description = "实际支付总金额(分)")
    private Integer actualAmount;

    @Schema(description = "配送公司")
    private String operCompany;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "配送时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] deliveryTime;

    @Schema(hidden = true)
    private Long creator;

    @Schema(description = "创建月份(yyyy-MM)")
    private String createYearMonth;

    @Schema(description = "筛选待评价")
    private Boolean filterToBeScore;

    @Schema(description = "是否已评价")
    private Boolean hasScore;


    @Schema(description = "联系人")
    private String contactUser;

    @Schema(description = "联系号码")
    private String contactPhone;

}