package cn.iocoder.foodnexus.module.operations.service.inquireprice;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquireprice.InquirePriceDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 询价管理 Service 接口
 *
 * @author 超级管理员
 */
public interface InquirePriceService {

    /**
     * 创建询价管理
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createInquirePrice(@Valid InquirePriceSaveReqVO createReqVO);

    /**
     * 更新询价管理
     *
     * @param updateReqVO 更新信息
     */
    void updateInquirePrice(@Valid InquirePriceSaveReqVO updateReqVO);

    /**
     * 删除询价管理
     *
     * @param id 编号
     */
    void deleteInquirePrice(Long id);

    /**
    * 批量删除询价管理
    *
    * @param ids 编号
    */
    void deleteInquirePriceListByIds(List<Long> ids);

    /**
     * 获得询价管理
     *
     * @param id 编号
     * @return 询价管理
     */
    InquirePriceDO getInquirePrice(Long id);

    /**
     * 获得询价管理分页
     *
     * @param pageReqVO 分页查询
     * @return 询价管理分页
     */
    PageResult<InquirePriceDO> getInquirePricePage(InquirePricePageReqVO pageReqVO);

    /**
     * 推送询价
     * @param pushReqVO
     */
    void pushInquirePrice(@Valid InquirePricePushReqVO pushReqVO);

    List<InquirePriceDO> getInquirePrice(List<Long> collect);

    default Map<Long, InquirePriceDO> getMap(List<Long> collect) {
        return CommonUtil.listConvertMap(getInquirePrice(collect), InquirePriceDO::getId);
    }
}