package cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaffcustomer;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 配送员客户绑定 DO
 *
 * @author 超级管理员
 */
@TableName("oper_delivery_staff_customer")
@KeySequence("oper_delivery_staff_customer_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeliveryStaffCustomerDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 配送员id
     */
    private Long deliveryStaffId;
    /**
     * 客户id/灶点id
     */
    private Long targetId;
    /**
     * false-客户/true-灶点
     */
    private Boolean isDept;


}