package cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo.InquirePriceRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

@Schema(description = "APP - 询价推送-客户 Response VO")
@Data
@ExcelIgnoreUnannotated
public class AppInquireCustomerPushRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "25862")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21995")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "询价主题id", requiredMode = Schema.RequiredMode.REQUIRED, example = "1397")
    @ExcelProperty("询价主题id")
    private Long inquirePriceId;

    @Schema(description = "是否确认", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否确认")
    private Boolean confirm;

    @Schema(description = "确认人员")
    @ExcelProperty("确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    @ExcelProperty("确认时间")
    private LocalDateTime confirmTime;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "询价主题明细")
    private InquirePriceRespVO inquirePrice;

    @Schema(description = "报价商品数量")
    private Long inquirePriceItemCount;

}