package cn.iocoder.foodnexus.module.operations.controller.app.delivery;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo.DeliveryStaffRespVO;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo.DeliveryStaffSaveReqVO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaff.DeliveryStaffDO;
import cn.iocoder.foodnexus.module.operations.service.deliverystaff.DeliveryStaffService;
import cn.iocoder.foodnexus.module.operations.service.deliverystaffcustomer.DeliveryStaffCustomerService;
import cn.iocoder.foodnexus.module.operations.service.vehicleinfo.VehicleInfoService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

/**
 * @author : yanghao
 * create at:  2025/10/14  16:14
 * @description: 配送员 - 个人信息
 */
@Tag(name = "配送员 - 个人信息")
@RestController
@RequestMapping("/delivery/oper")
@Validated
@AppSystemAuth(UserSystemEnum.DELIVERY)
public class AppDeliveryStaffController {

    @Autowired
    private DeliveryStaffService deliveryStaffService;

    @Resource
    private VehicleInfoService vehicleInfoService;


    @GetMapping("/get")
    @Operation(summary = "获得配送员信息")
    public CommonResult<DeliveryStaffRespVO> getDeliveryStaff() {
        DeliveryStaffDO deliveryStaff = deliveryStaffService.getDeliveryStaffByUserId(SecurityFrameworkUtils.getLoginUserId());
        return success(BeanUtils.toBean(deliveryStaff, DeliveryStaffRespVO.class, item -> {
            // item.setCustomerList(deliveryStaffCustomerService.queryCustomerListByDeliveryStaffId(item.getId()));
            item.setVehicleInfo(vehicleInfoService.queryByStaffId(item.getId()));
            // item.setCustomerDeptList(deliveryStaffCustomerService.queryDeptListByStaffId(item.getId()));
        }));
    }

}
