package cn.iocoder.foodnexus.module.erp.dal.dataobject.sale;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.product.ErpProductDO;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.product.dal.dataobject.spu.ProductSpuDO;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * ERP 销售订单项 DO
 *
 * @author 芋道源码
 */
@TableName("erp_sale_order_items")
@KeySequence("erp_sale_order_items_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpSaleOrderItemDO extends BaseDO {

    /**
     * 编号
     */
    @TableId
    private Long id;
    /**
     * 销售订单编号
     *
     * 关联 {@link ErpSaleOrderDO#getId()}
     */
    private Long orderId;
    /**
     * 客户订单子项id
     * @link // CustomerOrderItemDO#getId()
     */
    private Long customerOrderItemId;
    /**
     * 产品编号
     *
     * 关联 {@link ProductSpuDO#getId()}
     */
    private Long productId;
    /**
     * 产品单位单位
     *
     */
    private String productUnit;

    /**
     * 产品单位单价，单位：分
     */
    private Integer productPrice;
    /**
     * 数量
     */
    private Integer count;
    /**
     * 总价，单位：分
     *
     * totalPrice = productPrice * count
     */
    private Integer totalPrice;
    /**
     * 税率，百分比
     */
    private BigDecimal taxPercent;
    /**
     * 税额，单位：分
     *
     * taxPrice = totalPrice * taxPercent
     */
    private BigDecimal taxPrice;

    /**
     * 备注
     */
    private String remark;

    // ========== 销售出库 ==========
    /**
     * 销售出库数量
     */
    private BigDecimal outCount;

    // ========== 销售退货（入库）） ==========
    /**
     * 销售退货数量
     */
    private BigDecimal returnCount;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 拣货状态
     *
     * {@link SaleOrderPickUpStatus}
     */
    private SaleOrderPickUpStatus pickUpStatus;

    /**
     * 采购订单id
     */
    private Long purchaseOrderId;

    /**
     * 检获时间
     */
    private LocalDateTime pickUpTime;

}