package cn.iocoder.foodnexus.module.erp.api.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/8/30  14:29
 * @description: 仓库等级
 */
@Getter
@AllArgsConstructor
public enum WarehouseLevelEnum implements ArrayValuable<String> {

    WAREHOUSE("warehouse", "仓库"),

    WAREHOUSE_AREA("warehouse_area", "库区"),

    ;

    private final String key;

    private final String desc;


    public static final String[] ARRAYS = Arrays.stream(values()).map(WarehouseLevelEnum::getKey).toArray(String[]::new);

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }
}
