package cn.iocoder.foodnexus.module.system.dal.mysql.province;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.system.dal.dataobject.province.ProvinceDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.*;

/**
 * 地区数据 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface ProvinceMapper extends BaseMapperX<ProvinceDO> {

    default PageResult<ProvinceDO> selectPage(ProvincePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<ProvinceDO>()
                .eqIfPresent(ProvinceDO::getParentId, reqVO.getParentId())
                .likeIfPresent(ProvinceDO::getFullName, reqVO.getFullName())
                .likeIfPresent(ProvinceDO::getQuickQuery, reqVO.getQuickQuery())
                .eqIfPresent(ProvinceDO::getType, reqVO.getType())
                .orderByDesc(ProvinceDO::getId));
    }

}