package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

@Schema(description = "管理后台 - 客户订单-子订单新增/修改 Request VO")
@Data
public class AppCustomerOrderItemSaveReqVO {

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "9665")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品名称", example = "李四")
    private String productName;

    @Schema(description = "订单商品单价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED, example = "29922")
    @NotNull(message = "订单商品单价，单位：分不能为空")
    private Integer orderItemPrice;

    @Schema(description = "订单商品总价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "订单商品总价，单位：分不能为空")
    private Integer orderItemTotal;

    @Schema(description = "订单商品数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "订单商品数量不能为空")
    @Size(min = 1, message = "订单商品数量不能小于1")
    private Integer orderItemQuantity;

    @Schema(description = "商品对应供应商id", hidden = true)
    private Long supplierId;

    @Schema(description = "供应商名称", hidden = true)
    private String supplierName;

}