package cn.iocoder.foodnexus.module.operations.dal.dataobject.vehicleinfo;

import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 车辆信息 DO
 *
 * @author 超级管理员
 */
@TableName("oper_vehicle_info")
@KeySequence("oper_vehicle_info_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VehicleInfoDO extends BaseDO {

    /**
     * 序号，自增主键
     */
    @TableId
    private Long id;
    /**
     * 车牌号
     */
    private String licensePlate;
    /**
     * 车型
     */
    private String vehicleType;
    /**
     * 载重 (kg)
     */
    private Integer loadWeight;
    /**
     * 容积 (m³)
     */
    private BigDecimal volume;
    /**
     * 车辆绑定人员
     */
    private Long vehicleStaff;
    /**
     * 车辆绑定人员名称
     */
    private String vehicleStaffName;
    /**
     * 人员出生年份
     */
    private Integer staffYearBirth;
    /**
     * 人员联系方式
     */
    private String staffPhone;
    /**
     * 人员健康状态
     *
     * 枚举 {@link TODO oper_normal_status 对应的类}
     */
    private String staffHealthStatus;
    /**
     * 人员驾驶证状态
     *
     * 枚举 {@link TODO oper_normal_status 对应的类}
     */
    private String staffLicenseStatus;
    /**
     * 备注
     */
    private String remark;


}