package cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirepriceitem;

import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 询价管理子 DO
 *
 * @author 超级管理员
 */
@TableName("oper_inquire_price_item")
@KeySequence("oper_inquire_price_item_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InquirePriceItemDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 询价id
     */
    private Long inquireId;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品分类编号
     */
    private Long categoryId;
    /**
     * 分类名称
     */
    private String categoryName;
    /**
     * 市场价，单位使用：分
     */
    private Integer marketPrice;
    /**
     * 商品规格
     */
    private String productStandard;
    /**
     * 商品单位
     */
    private String productUnit;
    /**
     * 下浮率(%)
     */
    private BigDecimal floatingRate;
    /**
     * 下浮后价格（分）
     */
    private Integer floatingPrice;


}