package cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "APP - 询价推送-客户分页 Request VO")
@Data
public class AppInquireCustomerPushPageReqVO extends PageParam {

    @Schema(description = "客户id", example = "21995", hidden = true)
    private Long customerId;

    @Schema(description = "询价主题id", example = "1397")
    private Long inquirePriceId;

    @Schema(description = "是否确认")
    private Boolean confirm;

    @Schema(description = "确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] confirmTime;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;


    @Schema(description = "询价年月")
    private String inquiryYearMonth;

}