package cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

@Schema(description = "管理后台 - 车辆信息新增/修改 Request VO")
@Data
public class VehicleInfoSaveReqVO {

    @Schema(description = "序号，自增主键", requiredMode = Schema.RequiredMode.REQUIRED, example = "7574")
    private Long id;

    @Schema(description = "车牌号", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "车牌号不能为空")
    private String licensePlate;

    @Schema(description = "车型", example = "2")
    private String vehicleType;

    @Schema(description = "载重 (kg)")
    private Integer loadWeight;

    @Schema(description = "容积 (m³)")
    private BigDecimal volume;

    @Schema(description = "备注", example = "你猜")
    private String remark;

}