package cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 询价管理子分页 Request VO")
@Data
public class InquirePriceItemPageReqVO extends PageParam {

    @Schema(description = "询价id", example = "7342")
    private Long inquireId;

    @Schema(description = "商品id", example = "10941")
    private Long productId;

    @Schema(description = "商品分类编号", example = "13698")
    private Long categoryId;

    @Schema(description = "分类名称", example = "李四")
    private String categoryName;

    @Schema(description = "市场价，单位使用：分", example = "22500")
    private Integer marketPrice;

    @Schema(description = "商品规格")
    private String productStandard;

    @Schema(description = "商品单位")
    private String productUnit;

    @Schema(description = "下浮率(%)")
    private BigDecimal floatingRate;

    @Schema(description = "下浮后价格（分）", example = "2164")
    private Integer floatingPrice;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}