package cn.iocoder.foodnexus.module.erp.service.customerwarehouse;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo.*;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.customerwarehouse.CustomerWarehouseDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.erp.dal.mysql.customerwarehouse.CustomerWarehouseMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.erp.enums.ErrorCodeConstants.*;

/**
 * 客户绑定仓库 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class CustomerWarehouseServiceImpl implements CustomerWarehouseService {

    @Resource
    private CustomerWarehouseMapper customerWarehouseMapper;

    @Override
    public Long createCustomerWarehouse(CustomerWarehouseSaveReqVO createReqVO) {
        // 插入
        CustomerWarehouseDO customerWarehouse = BeanUtils.toBean(createReqVO, CustomerWarehouseDO.class);
        customerWarehouseMapper.insert(customerWarehouse);

        // 返回
        return customerWarehouse.getId();
    }

    @Override
    public void updateCustomerWarehouse(CustomerWarehouseSaveReqVO updateReqVO) {
        // 校验存在
        validateCustomerWarehouseExists(updateReqVO.getId());
        // 更新
        CustomerWarehouseDO updateObj = BeanUtils.toBean(updateReqVO, CustomerWarehouseDO.class);
        customerWarehouseMapper.updateById(updateObj);
    }

    @Override
    public void deleteCustomerWarehouse(Long id) {
        // 校验存在
        validateCustomerWarehouseExists(id);
        // 删除
        customerWarehouseMapper.deleteById(id);
    }

    @Override
        public void deleteCustomerWarehouseListByIds(List<Long> ids) {
        // 删除
        customerWarehouseMapper.deleteByIds(ids);
        }


    private void validateCustomerWarehouseExists(Long id) {
        if (customerWarehouseMapper.selectById(id) == null) {
            throw exception("客户仓库异常");
        }
    }

    @Override
    public CustomerWarehouseDO getCustomerWarehouse(Long id) {
        return customerWarehouseMapper.selectById(id);
    }

    @Override
    public PageResult<CustomerWarehouseDO> getCustomerWarehousePage(CustomerWarehousePageReqVO pageReqVO) {
        return customerWarehouseMapper.selectPage(pageReqVO);
    }

    /**
     * 根据客户id删除数据
     *
     * @param customerId
     */
    @Override
    public void deleteByCustomerId(Long customerId) {
        customerWarehouseMapper.delete(CustomerWarehouseDO::getCustomerId, customerId);
    }

    @Override
    public CustomerWarehouseDO getCustomerWarehouseByCustomerId(Long customerId) {
        return customerWarehouseMapper.selectOne(CustomerWarehouseDO::getCustomerId, customerId);
    }

    @Override
    public boolean exists(Long warehouseAreaId, Long customerId) {
        return customerWarehouseMapper.exists(Wrappers.<CustomerWarehouseDO>lambdaQuery()
                .eq(CustomerWarehouseDO::getCustomerId, customerId)
                .eq(CustomerWarehouseDO::getWarehouseAreaId, warehouseAreaId));
    }

}