package cn.iocoder.foodnexus.module.order.service.customeraddress;

import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressSaveReqVO;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;

import java.util.*;

import cn.iocoder.foodnexus.module.order.dal.dataobject.customeraddress.CustomerAddressDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.order.dal.mysql.customeraddress.CustomerAddressMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.module.order.enums.ErrorCodeConstants.*;

/**
 * 客户 - 我的地址 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class CustomerAddressServiceImpl implements CustomerAddressService {

    @Resource
    private CustomerAddressMapper customerAddressMapper;

    @Override
    public Long createCustomerAddress(CustomerAddressSaveReqVO createReqVO) {
        // 插入
        CustomerAddressDO customerAddress = BeanUtils.toBean(createReqVO, CustomerAddressDO.class);
        customerAddressMapper.insert(customerAddress);

        // 返回
        return customerAddress.getId();
    }

    @Override
    public void updateCustomerAddress(CustomerAddressSaveReqVO updateReqVO) {
        // 校验存在
        validateCustomerAddressExists(updateReqVO.getId());
        // 更新
        CustomerAddressDO updateObj = BeanUtils.toBean(updateReqVO, CustomerAddressDO.class);
        customerAddressMapper.updateById(updateObj);
    }

    @Override
    public void deleteCustomerAddress(Long id) {
        // 校验存在
        validateCustomerAddressExists(id);
        // 删除
        customerAddressMapper.deleteById(id);
    }

    @Override
        public void deleteCustomerAddressListByIds(List<Long> ids) {
        // 删除
        customerAddressMapper.deleteByIds(ids);
        }


    private void validateCustomerAddressExists(Long id) {
        if (customerAddressMapper.selectById(id) == null) {
            throw exception(CUSTOMER_ADDRESS_NOT_EXISTS);
        }
    }

    @Override
    public CustomerAddressDO getCustomerAddress(Long id) {
        return customerAddressMapper.selectById(id);
    }

    @Override
    public PageResult<CustomerAddressDO> getCustomerAddressPage(CustomerAddressPageReqVO pageReqVO) {
        return customerAddressMapper.selectPage(pageReqVO);
    }

    @Override
    public boolean existsById(Long addressId) {
        return customerAddressMapper.exists(Wrappers.<CustomerAddressDO>lambdaQuery()
                .eq(CustomerAddressDO::getId, addressId));
    }

}