package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderScoreRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/13  17:51
 * @description: 供应商评价
 */
@Data
public class CheckTaskSupplierScoreReqVO {

    @Schema(description = "供应商评价")
    private String scoreRemark;

    @Schema(description = "评价指标项")
    @Valid
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "评价指标id")
        @NotNull(message = "评价指标id不能为空")
        private Long scoreId;

        @Schema(description = "得分")
        @Min(value = 1, message = "得分最低1分")
        @Max(value = 5, message = "得分最高5分")
        private Integer score;

    }

}
