package cn.iocoder.foodnexus.module.erp.dal.dataobject.sale;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.finance.ErpAccountDO;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * ERP 销售订单 DO
 *
 * @author 芋道源码
 */
@TableName(value = "erp_sale_order", autoResultMap = true)
@KeySequence("erp_sale_order_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpSaleOrderDO extends BaseDO {

    /**
     * 编号
     */
    @TableId
    private Long id;
    /**
     * 销售订单号
     */
    private String no;
    /**
     * 销售状态
     *
     * 枚举 {@link ErpAuditStatus}
     */
    private Integer status;
    /**
     * 客户编号
     *
     * 关联 {@link ErpCustomerDO#getId()}
     */
    private Long customerId;
    /**
     * 灶点id
     */
    private Long customerDeptId;
    /**
     * 结算账户编号
     *
     * 关联 {@link ErpAccountDO#getId()}
     */
    private Long accountId;
    /**
     * 销售员编号
     *
     * 关联 AdminUserDO 的 id 字段
     */
    private Long saleUserId;
    /**
     * 下单时间
     */
    private LocalDateTime orderTime;

    /**
     * 合计数量
     */
    private Integer totalCount;
    /**
     * 最终合计价格，单位：分
     *
     * totalPrice = totalProductPrice + totalTaxPrice - discountPrice
     */
    private Integer totalPrice;

    /**
     * 合计产品价格，单位：分
     */
    private Integer totalProductPrice;
    /**
     * 合计税额，单位：分
     */
    private BigDecimal totalTaxPrice;
    /**
     * 优惠率，百分比
     */
    private BigDecimal discountPercent;
    /**
     * 优惠金额，单位：分
     *
     * discountPrice = (totalProductPrice + totalTaxPrice) * discountPercent
     */
    private BigDecimal discountPrice;
    /**
     * 定金金额，单位：分
     */
    private Integer depositPrice;

    /**
     * 附件地址
     */
    private String fileUrl;
    /**
     * 备注
     */
    private String remark;

    // ========== 销售出库 ==========
    /**
     * 销售出库数量
     */
    private BigDecimal outCount;

    // ========== 销售退货（入库）） ==========
    /**
     * 销售退货数量
     */
    private BigDecimal returnCount;

    /**
     * 客户订单id
     */
    private Long customerOrderId;

    /**
     * 配送模式
     *
     * 枚举 {@link DeliveryMode}
     */
    private DeliveryMode deliveryMode;

    /**
     * 配送时间（取货时间）
     */
    private LocalDateTime deliveryTime;

    /**
     * 接单时间
     */
    private LocalDateTime acceptTime;

    /**
     * 送达时间
     */
    private LocalDateTime arrivalTime;

    /**
     * 客户签收时间
     */
    private LocalDateTime signTime;

    /**
     * 配送人员
     *
     * DeliveryStaffDO
     */
    private Long deliveryStaffId;

    /**
     * 客户收货地址id
     */
    private Long addressId;

    /**
     * 客户收货地址info
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;

    /**
     * 拣货状态
     */
    private SaleOrderPickUpStatus pickUpStatus;

    /**
     * 收获仓库id
     */
    private Long warehouseId;
    /**
     * 收获库区id
     */
    private Long warehouseAreaId;
    /**
     * 仓库信息
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private WarehouseInfo warehouseInfo;

    /**
     * 预计配送开始时间
     */
    private LocalDateTime planDeliveryStartTime;
    /**
     * 预计配送结束时间
     */
    private LocalDateTime planDeliveryEndTime;
}