package cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order;

import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Schema(description = "管理后台 - ERP 销售订单新增/修改 Request VO")
@Data
public class ErpSaleOrderSaveReqVO {

    @Schema(description = "编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "17386")
    private Long id;

    @Schema(description = "客户编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1724")
    @NotNull(message = "客户编号不能为空")
    private Long customerId;

    @Schema(description = "灶点id")
    private Long customerDeptId;

    @Schema(description = "下单时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "下单时间不能为空")
    private LocalDateTime orderTime;

    @Schema(description = "销售员编号", example = "1888")
    private Long saleUserId;

    @Schema(description = "结算账户编号", example = "31189")
    private Long accountId;

    @Schema(description = "优惠率，百分比", requiredMode = Schema.RequiredMode.REQUIRED, example = "99.88")
    private BigDecimal discountPercent;

    @Schema(description = "定金金额，单位：分", example = "7127")
    private Integer depositPrice;

    @Schema(description = "附件地址", example = "https://www.iocoder.cn")
    private String fileUrl;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "客户订单id")
    @NotNull(message = "客户订单id不能为空")
    private Long customerOrderId;

    @Schema(description = "配送模式")
    private DeliveryMode deliveryMode;

    @Schema(description = "配送时间（取货时间）")
    private LocalDateTime deliveryTime;

    @Schema(description = "配送人员")
    private Long deliveryStaffId;

    @Schema(description = "客户收货地址id")
    private Long addressId;

    @Schema(description = "客户收货地址info")
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;

    @Schema(description = "收获仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "27065")
    private Long warehouseId;

    @Schema(description = "收获库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "26507")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;

    @Schema(description = "预计配送开始时间")
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "拣货状态")
    private SaleOrderPickUpStatus pickUpStatus;

    @Schema(description = "订单清单列表")
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "订单项编号", example = "11756")
        private Long id;

        @Schema(description = "客户订单子项id")
        private Long customerOrderItemId;

        @Schema(description = "产品编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "3113")
        @NotNull(message = "产品编号不能为空")
        private Long productId;

        @Schema(description = "产品单位单位", requiredMode = Schema.RequiredMode.REQUIRED, example = "3113")
        @NotNull(message = "产品单位单位不能为空")
        private String productUnit;

        @Schema(description = "产品单价", example = "100.00")
        private Integer productPrice;

        @Schema(description = "产品数量", requiredMode = Schema.RequiredMode.REQUIRED, example = "100.00")
        @NotNull(message = "产品数量不能为空")
        private Integer count;

        @Schema(description = "税率，百分比", example = "99.88")
        private BigDecimal taxPercent;

        @Schema(description = "备注", example = "随便")
        private String remark;

        @Schema(description = "供应商id")
        private Long supplierId;

        @Schema(description = "拣货状态")
        private SaleOrderPickUpStatus pickUpStatus;

    }

}