package cn.iocoder.foodnexus.module.order.service.shoppingcart;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo.ShoppingCartPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo.ShoppingCartSaveReqVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.shoppingcart.ShoppingCartDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 购物车 Service 接口
 *
 * @author 超级管理员
 */
public interface ShoppingCartService {

    /**
     * 创建购物车
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createShoppingCart(@Valid ShoppingCartSaveReqVO createReqVO);

    /**
     * 更新购物车
     *
     * @param updateReqVO 更新信息
     */
    void updateShoppingCart(@Valid ShoppingCartSaveReqVO updateReqVO);

    /**
     * 删除购物车
     *
     * @param id 编号
     */
    void deleteShoppingCart(Long id);

    /**
    * 批量删除购物车
    *
    * @param ids 编号
    */
    void deleteShoppingCartListByIds(List<Long> ids);

    /**
     * 获得购物车
     *
     * @param id 编号
     * @return 购物车
     */
    ShoppingCartDO getShoppingCart(Long id);

    /**
     * 获得购物车分页
     *
     * @param pageReqVO 分页查询
     * @return 购物车分页
     */
    PageResult<ShoppingCartDO> getShoppingCartPage(ShoppingCartPageReqVO pageReqVO);

}