package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.exception.ErrorCode;

/**
 * Product 错误码枚举类
 *
 * product 系统，使用 1-008-000-000 段
 */
public interface ErrorCodeConstants {
    // ========== 购物车 1_018-000-000 ==========
    ErrorCode SHOPPING_CART_NOT_EXISTS = new ErrorCode(1_018_100_000, "购物车不存在");

    // ========== 客户总订单 1_019_100_0001 ==========
    ErrorCode CUSTOMER_ORDER_NOT_EXISTS = new ErrorCode(1_019_100_001, "客户总订单不存在");
    ErrorCode CUSTOMER_ORDER_WAREHOUSE_NOEXISTS = new ErrorCode(1_019_100_002, "仓库不存在");
    ErrorCode CUSTOMER_WAREHOUSE_NOT_BIND = new ErrorCode(1_019_100_003, "所选仓库未绑定");

    // ========== 客户订单-子订单 1_020_100_0001 ==========
    ErrorCode CUSTOMER_ORDER_ITEM_NOT_EXISTS = new ErrorCode(1_020_100_001, "客户订单-子订单不存在");


    // ========== 客户订单进度记录 1_021_100_001 ==========
    ErrorCode CUSTOMER_ORDER_RECORD_NOT_EXISTS = new ErrorCode(1_021_100_001, "客户订单进度记录不存在");

}
