package cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 购物车新增/修改 Request VO")
@Data
public class ShoppingCartSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "12618")
    private Long id;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7172")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "王五")
    @NotEmpty(message = "商品名称不能为空")
    private String productName;

    @Schema(description = "单价(分)", requiredMode = Schema.RequiredMode.REQUIRED, example = "6013")
    @NotNull(message = "单价(分)不能为空")
    private Integer unitPrice;

    @Schema(description = "下单数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "下单数量不能为空")
    private Integer orderQuantity;

    @Schema(description = "备注", example = "随便")
    private String remark;

}