package cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 询价管理子 Response VO")
@Data
@ExcelIgnoreUnannotated
public class InquirePriceItemRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7765")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "询价id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7342")
    @ExcelProperty("询价id")
    private Long inquireId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "10941")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "商品分类编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "13698")
    @ExcelProperty("商品分类编号")
    private Long categoryId;

    @Schema(description = "分类名称", example = "李四")
    @ExcelProperty("分类名称")
    private String categoryName;

    @Schema(description = "市场价，单位使用：分", example = "22500")
    @ExcelProperty("市场价，单位使用：分")
    private Integer marketPrice;

    @Schema(description = "商品规格")
    @ExcelProperty("商品规格")
    private String productStandard;

    @Schema(description = "商品单位")
    @ExcelProperty("商品单位")
    private String productUnit;

    @Schema(description = "下浮率(%)")
    @ExcelProperty("下浮率(%)")
    private BigDecimal floatingRate;

    @Schema(description = "下浮后价格（分）", example = "2164")
    @ExcelProperty("下浮后价格（分）")
    private Integer floatingPrice;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}