package cn.iocoder.foodnexus.module.erp.api.service;

import cn.iocoder.foodnexus.module.erp.api.vo.supplier.SupplierAddReqVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author : yanghao
 * create at:  2025/8/30  11:23
 * @description: 供应商 api
 */
public interface ErpSupplierApi {

    void createByDept(Long deptId,@Valid @NotNull(message = "供应商不能为空") SupplierAddReqVO supplier);

    void updateByDept(Long deptId,@Valid @NotNull(message = "供应商不能为空") SupplierAddReqVO supplier);

    void deleteByDept(Long deptId);

    Long querySupplierIdByUserId(Long userId);

    Map<Long, String> queryNameMapByIds(Collection<Long> list);

    String queryNameById(Long supplierId);
}
