package cn.iocoder.foodnexus.module.erp.api.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;

/**
 * ERP 发货状态枚举
 */
@RequiredArgsConstructor
@Getter
public enum ErpDeliveryStatus implements ArrayValuable<String> {

    MATCHED("MATCHED", "已匹配"),
    NOT_YET("NOT_YET", "未发货"),
    ALREADY("ALREADY", "已发货"),
    ;

    public static final String[] ARRAYS = Arrays.stream(values()).map(ErpDeliveryStatus::getStatus).toArray(String[]::new);

    /**
     * 状态
     */
    private final String status;
    /**
     * 状态名
     */
    private final String name;

    @Override
    public String[] array() {
        return ARRAYS;
    }

}
