package cn.iocoder.foodnexus.framework.common.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/8/30  10:38
 * @description: 用户体系
 */
@Getter
@AllArgsConstructor
public enum UserSystemEnum implements ArrayValuable<String> {

    // 配送员
    DELIVERY("配送员", "DELIVERY"),
    // 供应商
    SUPPLIER("供应商", "SUPPLIER"),
    // 客户
    CUSTOMER("客户", "CUSTOMER"),
    // 运营人员
    OPER("运营人员", "OPER");

    private final String label;
    private final String key;

    // 根据标签获取对应的枚举
    public static UserSystemEnum getByLabel(String label) {
        for (UserSystemEnum dictionaryEnum : UserSystemEnum.values()) {
            if (dictionaryEnum.getLabel().equals(label)) {
                return dictionaryEnum;
            }
        }
        return null;
    }

    // 根据键值获取对应的枚举
    public static UserSystemEnum getByKey(String key) {
        for (UserSystemEnum dictionaryEnum : UserSystemEnum.values()) {
            if (dictionaryEnum.getKey().equals(key)) {
                return dictionaryEnum;
            }
        }
        return null;
    }

    public static final String[] ARRAYS = Arrays.stream(values()).map(UserSystemEnum::getKey).toArray(String[]::new);

    public static boolean isAppUser(String userSystem) {
        return !OPER.getKey().equals(CommonUtil.getEls(userSystem, ""));
    }

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }
}
