package cn.iocoder.foodnexus.module.system.dal.dataobject.province;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 地区数据 DO
 *
 * @author 超级管理员
 */
@TableName("system_province")
@KeySequence("system_province_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ProvinceDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 父级id
     */
    private Long parentId;
    /**
     * 名称
     */
    private String fullName;
    /**
     * quickQuery
     */
    private String quickQuery;
    /**
     * 类型（1-省份 2-市 3-县 4-街道）
     */
    private Integer type;


}