package cn.iocoder.foodnexus.module.system.controller.admin.province.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 地区数据新增/修改 Request VO")
@Data
public class ProvinceSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "17532")
    private Long id;

    @Schema(description = "父级id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21246")
    @NotNull(message = "父级id不能为空")
    private Long parentId;

    @Schema(description = "名称", example = "张三")
    private String fullName;

    @Schema(description = "quickQuery")
    private String quickQuery;

    @Schema(description = "类型（1-省份 2-市 3-县 4-街道）", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @NotNull(message = "类型（1-省份 2-市 3-县 4-街道）不能为空")
    private Integer type;

}