package cn.iocoder.foodnexus.module.system.controller.admin.province;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.web.bind.annotation.*;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import jakarta.validation.constraints.*;
import jakarta.validation.*;
import jakarta.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

import cn.iocoder.foodnexus.framework.excel.core.util.ExcelUtils;

import cn.iocoder.foodnexus.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.foodnexus.framework.apilog.core.enums.OperateTypeEnum.*;

import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.*;
import cn.iocoder.foodnexus.module.system.dal.dataobject.province.ProvinceDO;
import cn.iocoder.foodnexus.module.system.service.province.ProvinceService;

@Tag(name = "管理后台 - 地区数据")
@RestController
@RequestMapping("/system/province")
@Validated
public class ProvinceController {

    @Resource
    private ProvinceService provinceService;

    @GetMapping("/query")
    @Operation(summary = "获取省份信息")
    @Parameter(name = "parentId", description = "父级id")
    @Parameter(name = "type", description = "类型（1-省份 2-市 3-县区 4-街道）")
    @Parameter(name = "keyword", description = "查询字段")
    public CommonResult<List<ProvinceRespVO>> query(@RequestParam(value = "parentId", required = false) Long parentId,
                                                            @RequestParam(value = "type", required = false) Integer type,
                                                    @RequestParam(value = "keyword", required = false) String keyword) {
        if (CommonUtil.isEmpty(parentId) && CommonUtil.isEmpty(type) && CommonUtil.isEmpty(keyword)) {
            // 防止拉取所有数据
            return success(Lists.newArrayList());
        }
        return success(BeanUtils.toBean(provinceService.queryList(parentId, type, keyword), ProvinceRespVO.class));
    }

    @PostMapping("/create")
    @Operation(summary = "创建地区数据")
    public CommonResult<Long> createProvince(@Valid @RequestBody ProvinceSaveReqVO createReqVO) {
        return success(provinceService.createProvince(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新地区数据")
    public CommonResult<Boolean> updateProvince(@Valid @RequestBody ProvinceSaveReqVO updateReqVO) {
        provinceService.updateProvince(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除地区数据")
    @Parameter(name = "id", description = "编号", required = true)
    public CommonResult<Boolean> deleteProvince(@RequestParam("id") Long id) {
        provinceService.deleteProvince(id);
        return success(true);
    }

    @DeleteMapping("/delete-list")
    @Parameter(name = "ids", description = "编号", required = true)
    @Operation(summary = "批量删除地区数据")

    public CommonResult<Boolean> deleteProvinceList(@RequestParam("ids") List<Long> ids) {
        provinceService.deleteProvinceListByIds(ids);
        return success(true);
    }

}