package cn.iocoder.foodnexus.module.system.aspect;

import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.CookieSameSiteSupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author : yanghao
 * create at:  2025/11/18  13:41
 * @description:
 */
@Configuration
public class CookieConfig {

    @Bean
    public CookieSameSiteSupplier cookieSameSiteSupplier() {
        // 全局设置 SameSite=Strict（或 Lax，根据业务调整）
        return CookieSameSiteSupplier.ofStrict();
    }

    // 自定义 Cookie 处理器，添加 HttpOnly 和 Secure
    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            // 对所有 Cookie 生效
            servletContext.getSessionCookieConfig().setHttpOnly(true); // 禁止 JS 访问
            // servletContext.getSessionCookieConfig().setSecure(true); // 仅 HTTPS 传输（生产环境启用）
            // 可选：设置 Cookie 有效期（如 30 分钟）
            // servletContext.getSessionCookieConfig().setMaxAge(1800);
        };
    }
}