package cn.iocoder.foodnexus.module.order.service.checktask;

import java.util.*;

import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktask.CheckTaskDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 来料质检 Service 接口
 *
 * @author 超级管理员
 */
public interface CheckTaskService {

    /**
     * 创建来料质检
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCheckTask(@Valid CheckTaskSaveReqVO createReqVO);

    /**
     * 更新来料质检
     *
     * @param updateReqVO 更新信息
     */
    void updateCheckTask(@Valid CheckTaskSaveReqVO updateReqVO);

    /**
     * 删除来料质检
     *
     * @param id 编号
     */
    void deleteCheckTask(Long id);

    /**
    * 批量删除来料质检
    *
    * @param ids 编号
    */
    void deleteCheckTaskListByIds(List<Long> ids);

    /**
     * 获得来料质检
     *
     * @param id 编号
     * @return 来料质检
     */
    CheckTaskDO getCheckTask(Long id);

    /**
     * 获得来料质检分页
     *
     * @param pageReqVO 分页查询
     * @return 来料质检分页
     */
    PageResult<CheckTaskDO> getCheckTaskPage(CheckTaskPageReqVO pageReqVO);

    /**
     * 质检
     * @param updateReqVO
     */
    void check(CheckTaskCheckReqVO updateReqVO);

    CheckTaskSupplierScoreRespVO queryScore(Long id);

    CheckTaskDO queryScorebyPurchaseOrderId(Long purchaseOrderId);
}