package cn.iocoder.foodnexus.module.order.job;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.scoringweight.ScoringWeightDO;
import cn.iocoder.foodnexus.module.operations.service.scoringweight.ScoringWeightService;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderScoreReqVO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderDO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderrecord.CustomerOrderRecordDO;
import cn.iocoder.foodnexus.module.order.dal.mysql.customerorder.CustomerOrderMapper;
import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import cn.iocoder.foodnexus.module.order.service.orderScore.OrderScoreService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.yulichang.query.MPJLambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/11/14  09:41
 * @description: 客户订单定时任务
 */
@Component
@Slf4j
public class CustomerOrderScheduledTasks {

    @Autowired
    private CustomerOrderService customerOrderService;

    @Autowired
    private CustomerOrderMapper customerOrderMapper;

    @Autowired
    private ScoringWeightService scoringWeightService;

    public static final int DAYS = 7;

    public static final int SCORE = 4;

    // 每天凌晨3点执行一次
    // 查询签收、完成、退款订单中没有评价的订单，并给出默认订单评价
     @Scheduled(cron = "0 0 3 * * ?")
    public void defaultOrderScore() {
        // 默认时间
        LocalDate targetDate = LocalDate.now().minusDays(DAYS);
        LocalDateTime startTime = targetDate.atStartOfDay(); // xxxx-xx-xx 00:00:00
        LocalDateTime endTime = targetDate.atTime(LocalTime.MAX); // xxxx-xx-xx 23:59:59.999

        MPJLambdaWrapperX<CustomerOrderDO> query = new MPJLambdaWrapperX<>();
        query.eq(CustomerOrderDO::getHasScore, Boolean.FALSE)
                .in(CustomerOrderDO::getOrderStatus, CommonUtil.asList(CustomerOrderStatus.SIGN_RECEIPT.getKey(), CustomerOrderStatus.FINISH.getKey(), CustomerOrderStatus.RETURN.getKey()));
        query.leftJoin(CustomerOrderRecordDO.class, CustomerOrderRecordDO::getCustomerOrderId, CustomerOrderDO::getId);
        query.ge(CustomerOrderRecordDO::getCreateTime, startTime) // 大于等于起始时间
                .le(CustomerOrderRecordDO::getCreateTime, endTime);
        query.eq(CustomerOrderRecordDO::getOrderStatus, CustomerOrderStatus.SIGN_RECEIPT.getKey());

        List<CustomerOrderDO> customerOrderDOS = customerOrderMapper.selectList(query);
        log.info("每日默认订单评价,查询到订单:{}条", customerOrderDOS.size());
        if (CommonUtil.isEmpty(customerOrderDOS)) {
            return ;
        }
        int success = 0;
        for (CustomerOrderDO order : customerOrderDOS) {
            AppCustomerOrderScoreReqVO scoreReqVO = new AppCustomerOrderScoreReqVO();
            scoreReqVO.setOrderId(order.getId());
            List<ScoringWeightDO> scoringWeightDOS = scoringWeightService.queryByUserSystem(UserSystemEnum.CUSTOMER);
            scoreReqVO.setItems(CommonUtil.listConvert(scoringWeightDOS, item -> {
                AppCustomerOrderScoreReqVO.Item scoreItem = new AppCustomerOrderScoreReqVO.Item();
                scoreItem.setScoreId(item.getId());
                scoreItem.setScore(SCORE);
                return scoreItem;
            }));
            try {
                customerOrderService.score(scoreReqVO);
                success ++;
            } catch (Exception e) {
                log.error("每日默认订单评价，执行失败,客户订单编码【{}】", order.getCode(), e);
            }
        }
        log.info("每日默认订单评价,查询到订单:{}条,执行成功:{}条", customerOrderDOS.size(), success);
    }
}
