package cn.iocoder.foodnexus.module.order.dal.mysql.customerorderrecord;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderrecord.CustomerOrderRecordDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo.*;

/**
 * 客户订单进度记录 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerOrderRecordMapper extends BaseMapperX<CustomerOrderRecordDO> {

    default PageResult<CustomerOrderRecordDO> selectPage(CustomerOrderRecordPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerOrderRecordDO>()
                .eqIfPresent(CustomerOrderRecordDO::getCustomerOrderId, reqVO.getCustomerOrderId())
                .eqIfPresent(CustomerOrderRecordDO::getOrderStatus, reqVO.getOrderStatus())
                .eqIfPresent(CustomerOrderRecordDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerOrderRecordDO::getSupplierId, reqVO.getSupplierId())
                .eqIfPresent(CustomerOrderRecordDO::getMessageInfo, reqVO.getMessageInfo())
                .eqIfPresent(CustomerOrderRecordDO::getExtendInfo, reqVO.getExtendInfo())
                .eqIfPresent(CustomerOrderRecordDO::getCreator, reqVO.getCreator())
                .betweenIfPresent(CustomerOrderRecordDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CustomerOrderRecordDO::getId));
    }

}