package cn.iocoder.foodnexus.module.order.dal.dataobject.customeraddress;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 客户 - 我的地址 DO
 *
 * @author 超级管理员
 */
@TableName("order_customer_address")
@KeySequence("order_customer_address_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerAddressDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 联系人
     */
    private String contactUser;
    /**
     * 联系号码
     */
    private String contactPhone;
    /**
     * 省id
     */
    private Long provinceId;
    /**
     * 省name
     */
    private String provinceName;
    /**
     * 市
     */
    private Long cityId;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区
     */
    private Long regionId;
    /**
     * 区
     */
    private String regionName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 是否默认
     */
    private Boolean isDefault;


}