package cn.iocoder.foodnexus.module.order.controller.app.orderscore;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderRespVO;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderScoreRespVO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderDO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderitem.CustomerOrderItemDO;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import cn.iocoder.foodnexus.module.order.service.customerorderitem.CustomerOrderItemService;
import cn.iocoder.foodnexus.module.order.service.orderScore.OrderScoreService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;
import static cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils.getLoginUserId;

/**
 * @author : yanghao
 * create at:  2025/10/16  09:43
 * @description: APP - 个人中心 - 我的评价
 */
@Tag(name = "APP - 个人中心 - 我的评价")
@RestController
@RequestMapping("/my/order-score")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppCustomerOrderScoreController {

    @Autowired
    private CustomerOrderService customerOrderService;

    @Autowired
    private CustomerOrderItemService customerOrderItemService;

    @Autowired
    private OrderScoreService orderScoreService;

    @GetMapping("/page")
    @Operation(summary = "获得客户总订单分页")
    public CommonResult<PageResult<CustomerOrderScoreRespVO>> queryMyOrderScorePage(@Valid PageParam reqVO) {
        CustomerOrderPageReqVO pageReqVO = new CustomerOrderPageReqVO();
        pageReqVO.setPageNo(reqVO.getPageNo());
        pageReqVO.setPageSize(reqVO.getPageSize());
        pageReqVO.setCreator(getLoginUserId());
        pageReqVO.setHasScore(Boolean.TRUE);
        PageResult<CustomerOrderDO> pageResult = customerOrderService.getCustomerOrderPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, CustomerOrderScoreRespVO.class, item -> {
            item.setProductInfos(CommonUtil.listConvert(customerOrderItemService.queryByOrderId(item.getId()), CustomerOrderItemDO::getProductInfo));
            item.setOrderScoreItems(BeanUtils.toBean(orderScoreService.listByOrderId(item.getId()), CustomerOrderScoreRespVO.orderScoreItems.class));
        }));
    }

    @PostMapping("/delete-by-order-id")
    @Operation(summary = "根据订单id删除评价")
    @Parameter(name = "id", description = "订单id", required = true, example = "1024")
    public CommonResult<Boolean> deleteByOrderId(@RequestParam("id") Long id) {
        return success(orderScoreService.deleteByOrderId(id));
    }

}
