package cn.iocoder.foodnexus.module.order.controller.app.delivery;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.collection.MapUtils;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.DeliveryMyCountRespVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.DeliveryOrderPageReqVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.DeliveryStatusCountRespVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.ErpSaleOrderPageReqVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.returns.ErpSaleReturnRespVO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpCustomerDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpSaleOrderDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpSaleReturnDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpSaleReturnItemDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.stock.ErpStockDO;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.erp.service.sale.ErpSaleOrderService;
import cn.iocoder.foodnexus.module.erp.service.sale.ErpSaleReturnService;
import cn.iocoder.foodnexus.module.operations.service.deliverystaffcustomer.DeliveryStaffCustomerService;
import cn.iocoder.foodnexus.module.order.api.DeliveryStaffApi;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderRespVO;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo.CustomerOrderItemRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.delivery.vo.DeliveryOrderArrivalDetails;
import cn.iocoder.foodnexus.module.order.controller.app.delivery.vo.DeliveryOrderDetails;
import cn.iocoder.foodnexus.module.order.controller.app.delivery.vo.DeliverySaleOrderRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.delivery.vo.DeliverySaleReturnRespVO;
import cn.iocoder.foodnexus.module.order.dto.DeliveryOrderUpdateReqVO;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import cn.iocoder.foodnexus.module.order.service.customerorderitem.CustomerOrderItemService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import cn.iocoder.foodnexus.module.system.api.user.dto.AdminUserRespDTO;
import cn.iocoder.foodnexus.module.system.controller.admin.dept.vo.dept.DeptSimpleRespVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;
import static cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils.getLoginUserId;

/**
 * @author : yanghao
 * create at:  2025/10/14  17:56
 * @description: 配送员 - 订单
 */
@Tag(name = "配送员 - 订单 - 退款")
@RestController
@RequestMapping("/delivery/sale-return")
@Validated
@AppSystemAuth(UserSystemEnum.DELIVERY)
public class DeliverySaleReturnController {

    @Autowired
    private DeliveryStaffApi deliveryStaffApi;

    @Autowired
    private ErpSaleReturnService saleReturnService;

    @Autowired
    private CustomerOrderService customerOrderService;

    @Autowired
    private CustomerOrderItemService customerOrderItemService;

    @Autowired
    private ErpSaleOrderService saleOrderService;

    @GetMapping("/get")
    @Operation(summary = "退货单详情")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    public CommonResult<DeliveryOrderDetails<DeliverySaleReturnRespVO>> getSaleOrder(@RequestParam("id") Long id) {
        ErpSaleOrderDO saleOrder = saleOrderService.validateSaleOrder(id);
        ErpSaleReturnDO saleReturn = saleReturnService.validateBySaleOrderId(saleOrder.getId());
        if (saleReturn == null) {
            return success(null);
        }
        DeliveryOrderDetails<DeliverySaleReturnRespVO> result = new DeliveryOrderDetails<>();
        result.setDeliveryInfo(BeanUtils.toBean(saleReturn, DeliverySaleReturnRespVO.class));
        result.setCustomerOrderInfo(BeanUtils.toBean(customerOrderService.getCustomerOrder(saleReturn.getCustomerOrderId()),
                CustomerOrderRespVO.class, item ->
                        item.setOrderItems(BeanUtils.toBean(customerOrderItemService.queryByOrderId(item.getId()), CustomerOrderItemRespVO.class))));
        return success(result);
    }

    // 订单到货 - 运营后台
    @PostMapping("/arrival")
    @Operation(summary = "订单到货")
    public CommonResult<Boolean> arrival(@RequestBody @Valid DeliveryOrderUpdateReqVO reqVO) {
        saleReturnService.arrival(reqVO, deliveryStaffApi.queryStaffIdByUserId(getLoginUserId()));
        return success(Boolean.TRUE);
    }

    @GetMapping("/arrival")
    @Operation(summary = "退货单 - 订单到货 详情")
    @Parameter(name = "id", description = "客户订单id(customerOrderInfo.id)", required = true)
    public CommonResult<List<DeliveryOrderArrivalDetails>> getSaleReturn(@RequestParam("id") Long id) {
        ErpSaleReturnDO saleReturn = saleReturnService.getSaleReturnByCustomerOrderId(id);
        if (saleReturn == null) {
            return success(null);
        }
        List<ErpSaleReturnItemDO> saleReturnItemList = saleReturnService.getSaleReturnItemListByReturnId(saleReturn.getId());
        return success(BeanUtils.toBean(saleReturnItemList, DeliveryOrderArrivalDetails.class));
    }

}
