package cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 客户 - 我的地址新增/修改 Request VO")
@Data
public class CustomerAddressSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15256")
    private Long id;

    @Schema(description = "客户id", hidden = true)
    private Long customerId;

    @Schema(description = "联系人", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "联系人不能为空")
    private String contactUser;

    @Schema(description = "联系号码", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "联系号码不能为空")
    private String contactPhone;

    @Schema(description = "省id", example = "24818")
    private Long provinceId;

    @Schema(description = "省name", example = "李四")
    private String provinceName;

    @Schema(description = "市", example = "22031")
    private Long cityId;

    @Schema(description = "市", example = "张三")
    private String cityName;

    @Schema(description = "区", example = "3268")
    private Long regionId;

    @Schema(description = "区", example = "赵六")
    private String regionName;

    @Schema(description = "详细地址")
    private String address;

    @Schema(description = "是否默认", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "是否默认不能为空")
    private Boolean isDefault;

}