package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;
import java.util.Set;

/**
 * @author : yanghao
 * create at:  2025/10/13  14:16
 * @description:
 */
@Data
public class AppCustomerYearOrderPageReqVO extends PageParam {

    @Schema(description = "年份(yyyy)")
    @NotNull(message = "年份不能为空")
    private String year;

    @Schema(description = "客户灶点集合", hidden = true)
    private Set<Long> deptIds;

    @Schema(description = "用户id", hidden = true)
    private Long creator;

    /*@Schema(description = "月份(1-12)")
    @Max(value = 12, message = "异常月份")
    @Min(value = 1, message = "异常月份")
    private Integer month;*/

}
