package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/10  15:20
 * @description: 客户订单评价
 */
@Data
public class AppCustomerOrderScoreRespVO {

    @Schema(description = "订单备注")
    private CustomerOrderRemark orderRemark;

    @Schema(description = "评价指标项")
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "评价指标id")
        private Long scoreId;

        @Schema(description = "评价指标名称")
        private String scoreName;

        @Schema(description = "得分")
        private Integer score;

    }

}
