package cn.iocoder.foodnexus.module.order.controller.app.customerOrder;

import cn.hutool.core.lang.Pair;
import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.erp.api.service.ErpCustomerApi;
import cn.iocoder.foodnexus.module.erp.api.vo.customer.DeptSimpleDTO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerMonthOrderRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerMonthOrderTotalRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderReconciliationReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerYearOrderPageReqVO;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;
import static cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils.getLoginUser;
import static cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils.getLoginUserId;

/**
 * @author : yanghao
 * create at:  2025/10/13  14:13
 * @description: APP - 订单对账
 */
@Tag(name = "APP - 对账")
@RestController
@RequestMapping("/order/reconciliation")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppCustomerOrderReconciliationController {

    @Autowired
    private CustomerOrderService customerOrderService;

    @Autowired
    private ErpCustomerApi customerApi;

    @GetMapping("/page-year")
    @Operation(summary = "分页获取月度账单(按年份)")
    public CommonResult<AppCustomerMonthOrderRespVO> pageYear(@Valid AppCustomerYearOrderPageReqVO reqVO) {
        // reqVO.setDeptIds(customerApi.queryCustomerDeptIdsByUserId(getLoginUserId()));
        Pair<Boolean, Set<Long>> pair = customerApi.queryCustomerOrUserByUserId(getLoginUserId());
        if (pair.getKey()) {
            if (CommonUtil.isEmpty(pair.getValue())) {
                return success(null);
            }
            reqVO.setDeptIds(pair.getValue());
        } else {
            reqVO.setCreator(getLoginUserId());
        }
        return success(customerOrderService.reconciliationPageYear(reqVO));
    }

    @GetMapping("/month-total")
    @Operation(summary = "分页获取客户订单(按月份)")
    @Parameter(name = "yearMonth", description = "年月(yyyy-MM)", required = true)
    public CommonResult<AppCustomerMonthOrderTotalRespVO> monthTotal(@RequestParam("yearMonth") String yearMonth) {
        // Set<Long> deptIds = customerApi.queryCustomerDeptIdsByUserId(getLoginUserId());
        Pair<Boolean, Set<Long>> pair = customerApi.queryCustomerOrUserByUserId(getLoginUserId());
        if (pair.getKey()) {
            if (CommonUtil.isEmpty(pair.getValue())) {
                return success(null);
            }
            return success(customerOrderService.monthTotal(yearMonth, pair.getValue(), null));
        } else {
            return success(customerOrderService.monthTotal(yearMonth, null, getLoginUserId()));
        }

    }

    @PostMapping("/confirm")
    @Operation(summary = "确认账单")
    public CommonResult<Boolean> confirm(@Valid AppCustomerOrderReconciliationReqVO reqVO) {
        customerOrderService.reconciliationConfirm(reqVO);
        return success(Boolean.TRUE);
    }

    @GetMapping("/query-customer-dept-id")
    @Operation(summary = "查询灶点信息")
    public CommonResult<List<DeptSimpleDTO>> queryCustomerDeptId() {
        return success(customerApi.querySubDeptByUserId(getLoginUserId()));
    }

}
