package cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo;

import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户订单-子订单分页 Request VO")
@Data
public class CustomerOrderItemPageReqVO extends PageParam {

    @Schema(description = "客户订单id", example = "15521")
    private Long orderId;

    @Schema(description = "客户id", example = "18288")
    private Long customerId;

    @Schema(description = "商品id", example = "9665")
    private Long productId;

    @Schema(description = "商品名称", example = "李四")
    private String productName;

    @Schema(description = "商品信息")
    private ProductInfo productInfo;

    @Schema(description = "商品对应供应商id", example = "19874")
    private Long supplierId;

    @Schema(description = "供应商名称", example = "芋艿")
    private String supplierName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "订单商品单价，单位：分", example = "29922")
    private Integer orderItemPrice;

    @Schema(description = "订单商品总价，单位：分")
    private Integer orderItemTotal;

    @Schema(description = "订单商品数量")
    private Integer orderItemQuantity;

    @Schema(description = "签收数量")
    private Integer signedQuantity;

    @Schema(description = "签收总价，单位：分")
    private Integer signedTotal;

}