package cn.iocoder.foodnexus.module.order.controller.admin.customerorder;

import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderReconPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.CustomerOrderReconPageRespVO;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

/**
 * @author : yanghao
 * create at:  2025/11/3  16:16
 * @description: 管理后台 - 客户对账
 */
@RestController
@RequestMapping("/oper/customr-order/reconciliation")
@Validated
public class OperCustomerOrderReconciliationController {

    @Autowired
    private CustomerOrderService customerOrderService;

    @GetMapping("/page")
    @Operation(summary = "分页获取月度账单")
    public CommonResult<PageResult<CustomerOrderReconPageRespVO>> page(@Valid CustomerOrderReconPageReqVO pageReqVO) {
        return success(customerOrderService.pageReconciliation(pageReqVO));
    }


}
