package cn.iocoder.foodnexus.module.order.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/28  17:35
 * @description: 配送订单 - 实际配送信息
 */
@Data
public class DeliveryOrderUpdateReqVO {

    @Schema(description = "客户订单id(customerOrderInfo.id)")
    @NotNull(message = "客户订单id(customerOrderInfo.id)")
    private Long id;

    @Schema(description = "子项")
    @NotNull(message = "子项不能为空")
    @Valid
    @Size(min = 1, message = "子项不能为空")
    private List<DeliveryOrderUpdateItems> orderItems;

    @Data
    public static class DeliveryOrderUpdateItems {

        @Schema(description = "客户子订单id")
        @NotNull(message = "客户子订单id不能为空")
        private Long id;

        @Schema(description = "实际签收数量")
        @NotNull(message = "实际签收数量不能为空")
        @Min(value = 0, message = "实际签收数量最小为0")
        private Integer signedQuantity;

        @Schema(description = "说明")
        private String remark;

        @Schema(description = "相关文件")
        private List<String> remarkFiles;

    }
}
