package cn.iocoder.foodnexus.module.operations.service.vehicleinfo;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.vehicleinfo.VehicleInfoDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 车辆信息 Service 接口
 *
 * @author 超级管理员
 */
public interface VehicleInfoService {

    /**
     * 创建车辆信息
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createVehicleInfo(@Valid VehicleInfoSaveReqVO createReqVO);

    /**
     * 更新车辆信息
     *
     * @param updateReqVO 更新信息
     */
    void updateVehicleInfo(@Valid VehicleInfoSaveReqVO updateReqVO);

    /**
     * 删除车辆信息
     *
     * @param id 编号
     */
    void deleteVehicleInfo(Long id);

    /**
    * 批量删除车辆信息
    *
    * @param ids 编号
    */
    void deleteVehicleInfoListByIds(List<Long> ids);

    /**
     * 获得车辆信息
     *
     * @param id 编号
     * @return 车辆信息
     */
    VehicleInfoDO getVehicleInfo(Long id);

    /**
     * 获得车辆信息分页
     *
     * @param pageReqVO 分页查询
     * @return 车辆信息分页
     */
    PageResult<VehicleInfoDO> getVehicleInfoPage(VehicleInfoPageReqVO pageReqVO);

    void vehicleBind(VehicleInfoBindReqVO updateReqVO);

    void releaseBind(Long id);

    VehicleInfoRespVO queryByStaffId(Long staffId);
}