package cn.iocoder.foodnexus.module.operations.service.deliverystaffcustomer;

import java.util.*;

import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.customer.ErpCustomerRespVO;
import cn.iocoder.foodnexus.module.system.controller.admin.dept.vo.dept.DeptSimpleRespVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaffcustomer.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaffcustomer.DeliveryStaffCustomerDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 配送员客户绑定 Service 接口
 *
 * @author 超级管理员
 */
public interface DeliveryStaffCustomerService {

    /**
     * 创建配送员客户绑定
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createDeliveryStaffCustomer(@Valid DeliveryStaffCustomerSaveReqVO createReqVO);

    /**
     * 更新配送员客户绑定
     *
     * @param updateReqVO 更新信息
     */
    void updateDeliveryStaffCustomer(@Valid DeliveryStaffCustomerSaveReqVO updateReqVO);

    /**
     * 删除配送员客户绑定
     *
     * @param id 编号
     */
    void deleteDeliveryStaffCustomer(Long id);

    /**
    * 批量删除配送员客户绑定
    *
    * @param ids 编号
    */
    void deleteDeliveryStaffCustomerListByIds(List<Long> ids);

    /**
     * 获得配送员客户绑定
     *
     * @param id 编号
     * @return 配送员客户绑定
     */
    DeliveryStaffCustomerDO getDeliveryStaffCustomer(Long id);

    List<ErpCustomerRespVO> queryCustomerListByDeliveryStaffId(Long id);

    List<DeptSimpleRespVO> queryDeptListByStaffId(Long id);
}