package cn.iocoder.foodnexus.module.operations.service.customerrequire;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.customerrequire.CustomerRequireDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 客户需求 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerRequireService {

    /**
     * 创建客户需求
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerRequire(@Valid CustomerRequireSaveReqVO createReqVO);

    /**
     * 更新客户需求
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerRequire(@Valid CustomerRequireSaveReqVO updateReqVO);

    /**
     * 删除客户需求
     *
     * @param id 编号
     */
    void deleteCustomerRequire(Long id);

    /**
    * 批量删除客户需求
    *
    * @param ids 编号
    */
    void deleteCustomerRequireListByIds(List<Long> ids);

    /**
     * 获得客户需求
     *
     * @param id 编号
     * @return 客户需求
     */
    CustomerRequireDO getCustomerRequire(Long id);

    /**
     * 获得客户需求分页
     *
     * @param pageReqVO 分页查询
     * @return 客户需求分页
     */
    PageResult<CustomerRequireDO> getCustomerRequirePage(CustomerRequirePageReqVO pageReqVO);

    void require(Long id);
}