package cn.iocoder.foodnexus.module.operations.dal.mysql.deliverystaff;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaff.DeliveryStaffDO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.vehicleinfo.VehicleInfoDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo.*;

/**
 * 配送员信息 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface DeliveryStaffMapper extends BaseMapperX<DeliveryStaffDO> {

    default PageResult<DeliveryStaffDO> selectPage(DeliveryStaffPageReqVO reqVO) {
        MPJLambdaWrapperX<DeliveryStaffDO> wrapper = new MPJLambdaWrapperX<DeliveryStaffDO>()
                .likeIfPresent(DeliveryStaffDO::getName, reqVO.getName())
                .eqIfPresent(DeliveryStaffDO::getIdNumber, reqVO.getIdNumber())
                .eqIfPresent(DeliveryStaffDO::getContact, reqVO.getContact())
                .eqIfPresent(DeliveryStaffDO::getOnDutyStatus, reqVO.getOnDutyStatus())
                .eqIfPresent(DeliveryStaffDO::getStaffYearBirth, reqVO.getStaffYearBirth())
                .eqIfPresent(DeliveryStaffDO::getHealthStatus, reqVO.getHealthStatus())
                .eqIfPresent(DeliveryStaffDO::getDriverLicenseType, reqVO.getDriverLicenseType())
                .betweenIfPresent(DeliveryStaffDO::getLicenseStartTime, reqVO.getLicenseStartTime())
                .betweenIfPresent(DeliveryStaffDO::getLicenseEndTime, reqVO.getLicenseEndTime())
                .eqIfPresent(DeliveryStaffDO::getDriverLicenseStatus, reqVO.getDriverLicenseStatus())
                .eqIfPresent(DeliveryStaffDO::getHealthCertificateFile, reqVO.getHealthCertificateFile())
                .eqIfPresent(DeliveryStaffDO::getDriverLicenseFile, reqVO.getDriverLicenseFile())
                .eqIfPresent(DeliveryStaffDO::getRemark, reqVO.getRemark())
                .betweenIfPresent(DeliveryStaffDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeliveryStaffDO::getId);
        if (CommonUtil.isNotEmpty(reqVO.getFilterVirgin()) && reqVO.getFilterVirgin()) {
            wrapper.leftJoin(VehicleInfoDO.class, VehicleInfoDO::getVehicleStaff, DeliveryStaffDO::getId);
            wrapper.isNull(VehicleInfoDO::getId);
            wrapper.groupBy(DeliveryStaffDO::getId);
        }
        return selectPage(reqVO, wrapper);
    }

}