package cn.iocoder.foodnexus.module.operations.dal.dataobject.scoringweight;

import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 评分权重 DO
 *
 * @author 超级管理员
 */
@TableName("oper_scoring_weight")
@KeySequence("oper_scoring_weight_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ScoringWeightDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 评价指标名称
     */
    private String scoreName;
    /**
     * 评分权重
     */
    private BigDecimal weightRatio;
    /**
     * 是否展示
     */
    private Boolean isDisplay;
    /**
     * 面向用户群体
     *
     * 枚举 {@link TODO USER_SYSTEM 对应的类}
     */
    private String userSystem;
    /**
     * 排序
     */
    private Integer sort;

    /**
     * web端是否展示
     */
    private Boolean webDisplay;


}