package cn.iocoder.foodnexus.module.operations.dal.dataobject.customerrequire;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 客户需求 DO
 *
 * @author 超级管理员
 */
@TableName("oper_customer_require")
@KeySequence("oper_customer_require_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerRequireDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 需求标题
     */
    private String requireTitle;
    /**
     * 需求内容
     */
    private String requireContent;
    /**
     * 商品分类编号
     */
    private Long categoryId;
    /**
     * 是否受理
     */
    private Boolean isRequire;
    /**
     * 受理时间
     */
    private LocalDateTime requireTime;


}