package cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush;

import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils;
import cn.iocoder.foodnexus.module.erp.api.service.ErpCustomerApi;
import cn.iocoder.foodnexus.module.erp.service.product.ErpProductService;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo.InquirePriceRespVO;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.InquirePriceItemRespVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushRespVO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush.InquireCustomerPushDO;
import cn.iocoder.foodnexus.module.operations.service.inquirecustomerpush.InquireCustomerPushService;
import cn.iocoder.foodnexus.module.operations.service.inquireprice.InquirePriceService;
import cn.iocoder.foodnexus.module.operations.service.inquirepriceitem.InquirePriceItemService;
import cn.iocoder.foodnexus.module.product.api.ProductSpuApi;
import cn.iocoder.foodnexus.module.product.service.spu.ProductSpuService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

@Tag(name = "APP - 询价推送-客户")
@RestController
@RequestMapping("/operations/inquire-customer-push")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppInquireCustomerPushController {

    @Resource
    private InquireCustomerPushService inquireCustomerPushService;

    @Autowired
    private ErpCustomerApi customerApi;

    @Autowired
    private InquirePriceService inquirePriceService;

    @Autowired
    private InquirePriceItemService inquirePriceItemService;

    @Autowired
    private ProductSpuService productService;

    @PostMapping("/confirm")
    @Operation(summary = "确认询价")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    public CommonResult<Boolean> confirm(@RequestParam("id") Long id) {
        inquireCustomerPushService.confirm(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得询价推送-客户")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    public CommonResult<AppInquireCustomerPushRespVO> getInquireCustomerPush(@RequestParam("id") Long id) {
        InquireCustomerPushDO inquireCustomerPush = inquireCustomerPushService.getInquireCustomerPush(id);
        return success(BeanUtils.toBean(inquireCustomerPush, AppInquireCustomerPushRespVO.class, item -> {
            item.setInquirePrice(BeanUtils.toBean(inquirePriceService.getInquirePrice(inquireCustomerPush.getInquirePriceId()), InquirePriceRespVO.class, inquire -> {
                inquire.setItems(BeanUtils.toBean(inquirePriceItemService.queryByInquireId(inquire.getId()), InquirePriceItemRespVO.class, inquireItem -> {
                    inquireItem.setProductName(productService.queryName(inquireItem.getProductId()));
                }));
            }));
            item.setInquirePriceItemCount((long) Optional.ofNullable(item.getInquirePrice().getItems()).orElse(Lists.newArrayList()).size());
        }));
    }

    @GetMapping("/page")
    @Operation(summary = "获得询价推送-客户分页")
    public CommonResult<PageResult<AppInquireCustomerPushRespVO>> getInquireCustomerPushPage(@Valid AppInquireCustomerPushPageReqVO pageReqVO) {
        pageReqVO.setCustomerId(customerApi.queryCustomerIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        PageResult<AppInquireCustomerPushRespVO> pageResult = inquireCustomerPushService.getAppInquireCustomerPushPage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, AppInquireCustomerPushRespVO.class, item ->
                item.setInquirePrice(BeanUtils.toBean(inquirePriceService.getInquirePrice(item.getInquirePriceId()), InquirePriceRespVO.class))));
    }

}